@include('staff/header')

<div class="page-container">

    <!-- Content Wrapper START -->

    <div class="main-content">

        <div class="page-header">

            <h2 class="header-title">Whitelist Account</h2>

            <div class="header-sub-title">

                <nav class="breadcrumb breadcrumb-dash">

                    <a href="{{url('/staff/dashboard')}}" class="breadcrumb-item"><i class="anticon anticon-home m-r-5"></i>Home</a>                    

                    <span class="breadcrumb-item active">Whitelist Account</span>

                </nav>

            </div>

        </div>

        <div class="card">

            <div class="card-body">

                @if(session('success'))

                <div class="alert alert-success mb-1 mt-1">

                    {{ session('success') }}

                </div>

                @endif

                <form action="{{ url('/staff/add-bank-account') }}" method="POST" enctype="multipart/form-data">

                    @csrf

                    <div class="form-row">

                        <div class="col-md-4 mb-3">
                            <label for="">Select User</label>
                            <select class="is-valid1 form-control" name="user" require>
                                <!-- <option value="">Select user</option> -->
                                @if (!empty($users))
                                    @foreach ($users as $rows)
                                    <option value="{{$rows->id}}">{{$rows->name}}</option>
                                    @endforeach                                    
                                @endif
                            </select>
                            <div class="invalid-feedback" style="display: block!important;">
                            @error('user')
                                {{ $message }}
                            @enderror

                            </div>

                        </div>
                        <div class="col-md-4 mb-3">

                            <label for="">Account Holder Name</label>

                            <input type="text" class="form-control is-valid1" id="benename" name="benename" placeholder="Account Holder Name" value="" >

                            <div class="invalid-feedback" style="display: block!important;">

                                @error('benename')

                                    {{ $message }}

                                @enderror

                            </div>

                        </div>

                        <div class="col-md-4 mb-3">

                            <label for="">Account Number</label>

                            <input type="text" class="form-control is-invalid1" id="beneaccount" name="beneaccount" placeholder="Account Number" >

                            <div class="invalid-feedback" style="display: block!important;">

                                @error('beneaccount')

                                    {{ $message }}

                                @enderror

                            </div>

                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="">IFSC Code</label>
                            <input type="text" class="form-control is-invalid1" id="ifsccode" name="ifsccode" placeholder="IFSC Code" >
                            <div class="invalid-feedback" style="display: block!important;">
                                @error('ifsccode')
                                {{ $message }}
                            @enderror
                            </div>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="">Pancard</label>
                            <input type="file" class="form-control is-invalid1" id="pancard" name="pancard" placeholder="pancard" >
                            <div class="invalid-feedback" style="display: block!important;">
                                @error('pancard')
                                {{ $message }}
                            @enderror
                            </div>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="">Aadhaar Front</label>
                            <input type="file" class="form-control is-invalid1" id="aadhaarfront" name="aadhaarfront" placeholder="aadhaar front" >
                            <div class="invalid-feedback" style="display: block!important;">
                                @error('aadhaarfront')
                                {{ $message }}
                            @enderror
                            </div>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="">Aadhaar Back</label>
                            <input type="file" class="form-control is-invalid1" id="aadhaarback" name="aadhaarback" placeholder="aadhaar back" >
                            <div class="invalid-feedback" style="display: block!important;">
                                @error('aadhaarback')
                                {{ $message }}
                            @enderror
                            </div>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="">Cancel Cheque</label>
                            <input type="file" class="form-control is-invalid1" id="cancelcheque" name="cancelcheque" placeholder="Cancel Cheque" >
                            <div class="invalid-feedback" style="display: block!important;">
                                @error('cancelcheque')
                                {{ $message }}
                            @enderror
                            </div>
                        </div>
                        <br>
                        <div class="form-group text-center">

                            <button class="btn btn-primary">Submit</button>

                        </div>

                    </div>

                </form>

            </div>

        </div>

        <div class="row">

                        <div class="col-md-12 col-lg-12">

                            <div class="card">

                                <div class="card-body">

                                    <div class="d-flex justify-content-between align-items-center">

                                        <h5>Bank Account</h5>

                                        <div>

                                            

                                        </div>

                                    </div>

                                    <div class="m-t-30">

                                        <div class="table-responsive">

                                            <table class="table table-hover table-bordered">
                                                <thead>
                                                    <tr>
                                                        <th>Date</th>                                                        
                                                        <th>Name</th>
                                                        <th>Account Number</th>
                                                        <th>IFSC</th>
                                                        <th>Status</th>
                                                    </tr>
                                                </thead>

                                                <tbody>

                                                    @if (!empty($bankdata))

                                                        @foreach ($bankdata as $rows)

                                                        <tr>

                                                            <td>{{$rows->created_at}}</td>                                                                                                                                                                                
                                                            <td>{{$rows->beneName}}</td>
                                                            <td>{{$rows->beneAccount}}</td>     
                                                            <td>{{$rows->beneIfsc}}</td>                                                          
                                                            <td>
                                                                @if ($rows->status == 1)
                                                                    <button class="btn btn-sm btn-success">
                                                                        Approved
                                                                    </button>
                                                                @else
                                                                    <button class="btn btn-sm btn-danger">
                                                                    PENDING
                                                                    </button>
                                                                @endif

                                                            </td>                                           

                                                        </tr>

                                                        @endforeach

                                                    @endif

                                                </tbody>

                                            </table>

                                        </div>

                                    </div>

                                </div>

                            </div>

                        </div>

                       

                    </div>

    </div>

</div>

@include('staff/footer')