<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class AdminAuthentication
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if(auth()->user() && auth()->user()->user_type == 0){
            $allSessions = session()->all();
            if($allSessions['checkLoginStatus'] != "pass"){
                auth()->logout();                
                // return redirect()->route('login')->with('success','Unauthorized user.');
                 return redirect()->route('login');
            }
            return $next($request);
        }

        return redirect('/logout');
    }
}
