<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Carbon;
use App\Models\User;
use App\Models\UserCharge;
use App\Models\UserIp;
use App\Models\UserTransaction;
use App\Models\PayoutModel;
use App\Models\ApiLog;

class CheckStatusIserveUNew extends Controller
{
    
    public function checkStatus(Request $request){

        $jsonData = $request->json()->all();        
        $Authorization = $request->header('Authorization');

        $validator = Validator::make($request->all(), [
            'referenceNumber' => 'required',            
        ]);

        if($validator->fails()) {
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => $validator->errors(),
            ];
            return response()->json($responseData, 422); die;
        }

        $getUser = User::where("user_token",$Authorization)->where("status",1)->where("api_status",1)->where("user_type",1)->first();
        if(empty($getUser)){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'Invalid credentials.',
            ];
            return response()->json($responseData , 401); die;
        }

        $userId = $getUser->id;
        $ipAddress = $request->ip();
        $checkIp = UserIp::where(['userId'=>$userId,'ipAddress'=>$ipAddress])->first();
        if(empty($checkIp)){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'your ip is not whitlisted, requested ip is '.$ipAddress,
            ];
            //return response()->json($responseData , 401);
        }
        $referenceNumber = $request['referenceNumber'];
        $checkTxn = PayoutModel::where("orderId",$referenceNumber)->where("userId",$userId)->where("api","ISERVEU")->get()->toArray();
        if(count($checkTxn) == 0){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'Transation not found.',
            ];
            return response()->json($responseData , 200); die;
        }

        $TxnStatus = $checkTxn[0]['status'];
        $TxnApi = $checkTxn[0]['api'];

        if($TxnApi != "ISERVEU"){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'Transation not found',
            ];
            return response()->json($responseData , 200); die;
        }

        if($TxnStatus == "SUCCESS"){

            $TxnUtr = $checkTxn[0]['utr'];
            $responseData = [
                "status" => "SUCCESS",
                "message" => "Transaction is Successful",
                "data" => array(
                    "payout_ref" => $referenceNumber,
                    "bank_ref" => $TxnUtr
                ),
            ];
            return response()->json($responseData , 200);
            die;
        }

        if($TxnStatus == "FAILED"){

            $responseData = [
                "status" => "FAILED",
                "message" => "Transaction is failed",
                "data" => array(
                    "payout_ref" => $referenceNumber,
                    "bank_ref" => ""
                ),
            ];
            return response()->json($responseData , 200);
            die;
        }

        if($TxnStatus == "REFUNDED"){

            $responseData = [
                "status" => "FAILED",
                "message" => "Transaction is failed",
                "data" => array(
                    "payout_ref" => $referenceNumber,
                    "bank_ref" => ""
                ),
            ];
            return response()->json($responseData , 200);
            die;
        }

        
        
        $txnID = $checkTxn[0]['txnId'];
        $txnContactId = $checkTxn[0]['contactId'];
        $timestamp = $checkTxn[0]['created_at'];
        $totalDeductAmount = $checkTxn[0]['totalAmount'];

        //$ISERVEU_CLIENT_ID = "8a2d0eb01b53fa2ae4c2a2f1f0f1b7278058778345346dba11b175ce6fb5e8853b6557c0c03eee674cfae0aaf5c60118";
        //$ISERVEU_CLIENT_SECRET = "62cbc2f6c99b8e10393ba98458629319a8fe92da8bc3a9a0dee1156a1011010ddc2cbcb74472ace6d9708a60324f33d07ccfacef94ff27656dfbc6a007dfd196";
        
        //SHIKUL 
        
        $ISERVEU_CLIENT_ID = "19f0b82156edf5096bb7a4f5c67f70d52c8b0c0b2b642f102a951e541a227768cec17f97f0ca7df7e7f9089e670c2f97";
        $ISERVEU_CLIENT_SECRET = "6ef770dc482357db0635c61ea4dcfc10dad99834a1d7581a1ff8cc7dbfd467444f94508bb758d9d1213bb569bf73383b4caa2d1fa309443a959b909107d2c161";

        $header = array(
            'Content-Type:application/json',
            'client_id: ' . $ISERVEU_CLIENT_ID,
            'client_secret: ' . $ISERVEU_CLIENT_SECRET
        );
        $quesyOperation = "Cashout_addbank_status";
        $startDate = Carbon::parse($timestamp)->format('Y-m-d');
        $endDate = Carbon::parse($timestamp)->format('Y-m-d');
        $request = [
            "$1" => $quesyOperation,
            "$4" => $startDate,
            "$5" => $endDate,
            "$6" => $txnID,
            "$10" => $txnContactId
        ];

        $payload = json_encode($request);

        $curl = curl_init();

        curl_setopt_array($curl, [
            CURLOPT_URL => "https://apigatewayprod.iserveu.tech/statuscheck/txnreport",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $payload,
            CURLOPT_HTTPHEADER => $header
        ]);

        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);

        ApiLog::create([
            'txnId' => $txnID,
            'request' => $payload,
            'response' => $response,  
            'service' => "CHECKSTATUS",
            'service_api' =>"ISERVEU",   
        ]);

        if (empty($response)) {
            $response = [
                'status'   => 400,
                'error'    => true,
                'messages' => 'Something went wrong'
            ];
            return $this->respond($response, 400);
        }

        $responseData = json_decode($response, true);

        // if (isset($responseData['status']) && $responseData['status'] == 1) {
        //     return response()->json($response , 400); die;
        // }

        // if (isset($responseData['status']) && $responseData['status'] == 0) {
        //     return response()->json($response , 400); die;
        // }

        $message = @$responseData['message'];

        if($message == "Transaction response has no data for required parameters")
        {
            $updateUser = [
                'status' => "REFUNDED"
            ];  

            $UserTransaction = new UserTransaction();      
            $UserTransaction->updateUserTxnDataByOrderid($updateUser,$referenceNumber);
            
            $openBal = $getUser->wallet;

            $closeBal = $openBal + $totalDeductAmount;
            $UserInstance = new User();
            $UserInstance->addFund($userId,$totalDeductAmount);
            $remark = "Refund Amount Due To Payout Failure ";
            UserTransaction::create([
                'userId' => $userId,
                'txnId' => $txnID,
                'orderId' => $referenceNumber,
                'type' => "CREDIT",
                'operator' => "REFUND",
                'openBalance'=>$openBal,
                'amount' => $totalDeductAmount,
                'walletBalance' =>$closeBal,  
                'credit' =>$totalDeductAmount, 
                'debit' =>0, 
                'remark' => $remark,   
                'api'=>"ISERVEU",
                'status'=>"REFUNDED",
                'requestIp' => $ipAddress,
                "refundId"=>$txnID,    
                'created_by' => 1,
            ]);

            $updatePayout = [
                "contactId"=>"",                
                "status"=>"FAILED",
            ];                  
            $PayoutModel = new PayoutModel();      
            $PayoutModel->updatePayoutData($updatePayout,$txnID);

            

            $statusMessage = "Transaction is failed";
            $responseData = [
                "status" => "FAILED",
                "message" => $statusMessage,
                "data" => array(
                    "payout_ref" => $referenceNumber,
                    "bank_ref" => ""
                ),
            ];
            return response()->json($responseData , 200);
            die;
        }

        $status = @$responseData['results'][0]['status'];
        $rrn = @$responseData['results'][0]['rrn'];
        $contact = @$responseData['results'][0]['txnId'];
        $clientreferenceid = @$responseData['results'][0]['clientreferenceid'];
        $Client_ref_id =str_replace("#", "", $clientreferenceid);
        $contactId = str_replace("#", "", $contact);

        if($status == "SUCCESS"){

            $updatePayout = [
                "contactId"=>$contactId,
                "utr"=>$rrn,
                "status"=>"SUCCESS",
            ];                  
            $PayoutModel = new PayoutModel();      
            $PayoutModel->updatePayoutData($updatePayout,$txnID);

            $updateUser = [
                'status' => "SUCCESS"
            ];  

            $UserTransaction = new UserTransaction();      
            $UserTransaction->updateUserTxnDataByOrderid($updateUser,$referenceNumber);

            $responseData = [
                "status" => "SUCCESS",
                "message" => "Transaction Successful",
                "data" => array(
                    "payout_ref" => $referenceNumber,
                    "bank_ref" => $rrn
                ),
            ];
            return response()->json($responseData , 200);
            die;

        }else if($status == "FAILED" || $status == "REFUNDED"){


            $updateUser = [
                'status' => "REFUNDED"
            ];  

            $UserTransaction = new UserTransaction();      
            $UserTransaction->updateUserTxnDataByOrderid($updateUser,$referenceNumber);
            
            $openBal = $getUser->wallet;

            $closeBal = $openBal + $totalDeductAmount;
            $UserInstance = new User();
            $UserInstance->addFund($userId,$totalDeductAmount);
            $remark = "Refund Amount Due To Payout Failure ";
            UserTransaction::create([
                'userId' => $userId,
                'txnId' => $txnID,
                'orderId' => $referenceNumber,
                'type' => "CREDIT",
                'operator' => "REFUND",
                'openBalance'=>$openBal,
                'amount' => $totalDeductAmount,
                'walletBalance' =>$closeBal,  
                'credit' =>$totalDeductAmount, 
                'debit' =>0, 
                'remark' => $remark,   
                'api'=>"ISERVEU",
                'status'=>"REFUNDED",
                'requestIp' => $ipAddress,
                "refundId"=>$txnID,    
                'created_by' => 1,
            ]);

            $updatePayout = [
                "contactId"=>"",                
                "status"=>"FAILED",
            ];                  
            $PayoutModel = new PayoutModel();      
            $PayoutModel->updatePayoutData($updatePayout,$txnID);

            

            $statusMessage = "Transaction is failed";
            $responseData = [
                "status" => "FAILED",
                "message" => $statusMessage,
                "data" => array(
                    "payout_ref" => $referenceNumber,
                    "bank_ref" => ""
                ),
            ];
            return response()->json($responseData , 200);
            die;

        }else{

            $responseData = [
                "status" => "PENDING",
                "message" => "Transaction is under process",
                "data" => array(
                    "payout_ref" => $referenceNumber,
                    "bank_ref" => ""
                ),
            ];
            return response()->json($responseData , 200);
            die;
        }

        $responseData = [
            "status" => "PENDING",
            "message" => "Transaction is under process",
            "data" => array(
                "payout_ref" => $referenceNumber,
                "bank_ref" => ""
            ),
        ];
        return response()->json($responseData , 200);
        die;

        
    }

    public function getUserBalance(Request $request)
    {
        $jsonData = $request->json()->all();        
        $Authorization = $request->header('Authorization');

        $getUser = User::where("user_token",$Authorization)->where("status",1)->where("api_status",1)->where("user_type",1)->first();
        if(empty($getUser)){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'Invalid credentials',
            ];
            return response()->json($responseData , 401,); die;
        }

        $userId = $getUser->id;
        $ipAddress = $request->ip();

        $checkIp = UserIp::where(['userId'=>$userId,'ipAddress'=>$ipAddress])->first();
        if(empty($checkIp)){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'your ip is not whitlisted, requested ip is '.$ipAddress,
            ];
            return response()->json($responseData , 401);
        }

        $walletBal = $getUser->wallet;
        $responseData = [
            "status" => "SUCCESS",
            "message" => "Transaction is Successful",
            "data" => array(
                "balance" => $walletBal,
            ),
        ];
        return response()->json($responseData , 200,[],JSON_UNESCAPED_SLASHES);
        die;
    }


}


?>