

<?php echo $__env->make('admin/header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="page-container">

    <!-- Content Wrapper START -->

    <div class="main-content">

        <div class="page-header">

            <h2 class="header-title">Staff</h2>

            <div class="header-sub-title">

                <nav class="breadcrumb breadcrumb-dash">

                    <a href="<?php echo e(url('/admin/dashboard')); ?>" class="breadcrumb-item"><i class="anticon anticon-home m-r-5"></i>Home</a>                    

                    <span class="breadcrumb-item active">Staff</span>

                </nav>

            </div>

        </div>

        <div class="card">

            <div class="card-body">

                <?php if(session('success')): ?>

                    <div class="alert alert-success mb-1 mt-1">

                        <?php echo e(session('success')); ?>


                    </div>

                <?php endif; ?>

                <div class="row">

                    <div class="col-md-12 col-lg-12">                        

                        <div class="d-flex justify-content-between align-items-center">

                            <h5>Staff</h5>

                            <div>

                                <a href="<?php echo e(url('/admin/add-staff')); ?>" class="btn btn-sm btn-primary">Add Staff</a>

                            </div>

                        </div>

                            <div class="m-t-30">

                                <div class="table-responsive">

                                    <table class="table table-hover table-bordered">

                                        <thead>

                                            <tr>

                                                <th>Name</th>

                                                <th>Mobile</th>

                                                <th>Email</th>

                                                <th>Status</th>

                                                <th>Action</th>

                                            </tr>

                                        </thead>

                                        <tbody>

                                            <?php $__currentLoopData = $user; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rows): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                <tr>

                                                    <td><?php echo e($rows->name); ?></td>                                                    

                                                    <td><?php echo e($rows->mobile); ?></td>

                                                    <td><?php echo e($rows->email); ?></td>

                                                    <td>

                                                        <?php if($rows->status == 1): ?>

                                                            <button class="btn btn-sm btn-success" onClick="changeStatus(<?php echo e($rows->id); ?>,'DEACTIVE','status')">ACTIVE</button>

                                                        <?php else: ?>

                                                            <button class="btn btn-sm btn-danger" onClick="changeStatus(<?php echo e($rows->id); ?>,'ACTIVE','status')">DEACTIVE</button>

                                                        <?php endif; ?>

                                                    </td>                                                    

                                                    <td>                                                    
                                                        <button class="btn btn-sm btn-info" onClick="resetPssword(<?php echo e($rows->id); ?>)">Reset Password</button>
                                                        <a class="btn btn-icon btn-success" href="<?php echo e(url('admin/manage-staff-ip/'.$rows->id)); ?>">

                                                            <i class="anticon anticon-plus"></i>

                                                        </a>
                                                    </td>
                                                </tr>

                                                 <!-- model Stting-->

                                                 <div class="modal fade" id="setting_<?php echo e($rows->id); ?>">

                                                    <div class="modal-dialog modal-dialog-scrollable">

                                                    <div class="modal-content">

                                                    <div class="modal-header">

                                                        <h5 class="modal-title" id="exampleModalScrollableTitle">Ip Setting</h5>

                                                        <button type="button" class="close" data-dismiss="modal">

                                                            <i class="anticon anticon-close"></i>

                                                        </button>

                                                    </div>

                                                        <div class="modal-body">

                                                        <form action="<?php echo e(url('admin/save-satff-ip')); ?>" method="POST">

                                                        <?php echo csrf_field(); ?>
                                                    
                                                        <div class="form-group">

                                                            <label for="inputAddress">Ip Address</label>

                                                            <input type="text" class="form-control" name="ipaddress" placeholder="Ip Address" value="">

                                                        </div>                                                        
                                                        <input type="hidden" name="userid" value="<?php echo e($rows->id); ?>"/>

                                                            

                                                        </div>

                                                        <div class="modal-footer">

                                                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>

                                                            <button type="submit" class="btn btn-primary">Save</button>

                                                        </div>

                                                    </form>

                                                    </div>

                                                    </div>

                                                    </div>


                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>                                            

                                        </tbody>

                                    </table>

                                    <?php echo $user->links(); ?>


                                </div>

                            </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>

<script>    



    function changeStatus(id,status,type){

        var csrfToken = $('meta[name="csrf-token"]').attr('content');
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': csrfToken
            }
        });

        var url = '<?php echo e(url('/admin/update-users-status')); ?>';
        $.ajax({

            type: 'POST',
            url: url,
            data: {

                'id':id,
                'status':status,
                'type':type
            },

            success: function (response) {
               alert(response);
               location.reload();
            }
        });

    }

    function resetPssword(id){

        var csrfToken = $('meta[name="csrf-token"]').attr('content');
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': csrfToken
            }
        });

        var url = '<?php echo e(url('/admin/reset-users-password')); ?>';
        $.ajax({

            type: 'POST',
            url: url,
            data: {
                'id':id,
            },
            success: function (response) {
            alert(response);
            location.reload();
            }
        });

        }



</script>

    

<?php echo $__env->make('admin/footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dashboardseospay/public_html/dashboard.seospay.tech/resources/views/admin/manage-staff.blade.php ENDPATH**/ ?>