<!DOCTYPE html>

<html lang="en">



<head>

    <meta charset="UTF-8">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Seospay</title>

    <link rel="stylesheet" href="{{ asset('public/assets_front/css/bootstrap.min.css') }}">

    <link rel="stylesheet" href="{{ asset('public/assets_front/css/fontawesome.min.css') }}" />

    <link rel="stylesheet" href="https://pro.fontawesome.com/releases/v5.10.0/css/all.css" />

    <link rel="stylesheet" href="{{ asset('public/assets_front/css/style.css') }} "/>

    <link rel="stylesheet" href="{{ asset('public/assets_front/css/header.css') }}">

    <link rel="stylesheet" href="{{ asset('public/assets_front/css/animate.min.css') }}">

    <link rel="stylesheet" href="{{ asset('public/assets_front/css/slick.css') }}">

    <link rel="stylesheet" href="{{ asset('public/assets_front/css/slick-theme.css') }}">

    <link rel="stylesheet" href="{{ asset('public/assets_front/css/login.css') }}">
    <meta name="csrf-token" content="{{ csrf_token() }}">

</head>

<body>

    <section class="sign-in">

        <div class="container">

            <div class="signin-content row">

                <div class="col-lg-6 col-md-6">

                    <div class="signin-image">

                        <figure><img src="{{ asset('public/assets_front/images/signin-image1.jpg') }}" alt="sing up image"></figure>

                    </div>

                </div>

                <div class="col-lg-6 col-md-6">

                    <div class="login-form">

                        <h4>PayNow</h4>

                        <P> <span>Welcome Back !</span> <br>

                            Sign in to continue to PayNow.</P>

                            @if(session('success'))

                                <div class="alert alert-success mb-1 mt-1">

                                    {{ session('success') }}

                                </div>

                            @endif
                            @if(session('error'))
                                <div class="alert alert-danger">
                                    {{ session('error') }}
                                </div>
                            @endif
                        <form action="{{ url('verify-otp') }}" method="POST" enctype="multipart/form-data">

                            @csrf
                            
                            <div class="row">

                                <div class="col-lg-12">

                                    <div class="mb-3">

                                        <label for="exampleInputEmail1" class="form-label">Enter Pin/Otp</label>

                                        <input type="text" class="form-control" name="otp" id="otp"

                                            aria-describedby="emailHelp">

                                    </div>

                                    @error('otp')

                                        <div class="alert alert-danger mt-1 mb-1">{{ $message }}</div>

                                    @enderror

                                </div>
                            </div>
                            <div class="otp_button " style ="display:flex;align-content: space-between;">
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="pintype" value="PIN" id="flexRadioDefault1" checked>
                                    <label class="form-check-label" for="flexRadioDefault1">PIN</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="pintype" value="OTP" id="flexRadioDefault2" >
                                    <label class="form-check-label" for="flexRadioDefault2">
                                        OTP
                                    </label>
                                </div>
                                <div class="send_btn">
                                    <button type="button" class="btn btn-primary btn-sm ml-auto" style="margin-left: 380px;" onClick="sendOtp();">Send otp</button>
                                </div>
                            </div>

                            <button type="submit" class="sbtns">Verify</button>

                        </form>

                    </div>

                </div>

            </div>

        </div>

    </section>

    <script src="assets/js/jquery.min.js"></script>

    <script src="assets/js/bootstrap.bundle.min.js"></script>

    <script src="assets/js/slick.js"></script>

    <script src="assets/js/script.js"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

    <script>    



function sendOtp(){

    var csrfToken = $('meta[name="csrf-token"]').attr('content');
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': csrfToken
        }
    });

    var url = '{{url('/send-otp')}}';
    $.ajax({
        type: 'POST',
        url: url,
        data: {
            'type':"LOGIN"
        },
        success: function (response) {
           alert(response);
           //location.reload();
        }
    });
}
</script>

</body>



</html>