<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payout_transactions', function (Blueprint $table) {
            $table->id();
            $table->integer('userId');
            $table->string('orderId')->nullable();
            $table->string('txnId')->nullable();
            $table->string('contactId')->nullable();
            $table->double('amount', 14, 4)->default(0);
            $table->double('charge', 14, 4)->default(0);
            $table->double('gst', 14, 4)->default(0);
            $table->double('totalAmount', 14, 4)->default(0);
            $table->string('mode')->nullable();
            $table->string('beneName')->nullable();
            $table->string('beneBank')->nullable();
            $table->string('beneAccount')->nullable();
            $table->string('beneIfsc')->nullable();
            $table->string('utr')->nullable();
            $table->string('status')->nullable();   
            $table->string('IpAddress')->nullable();    
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payout_transactions');
    }
};
