<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_charge', function (Blueprint $table) {
            $table->id();
            $table->integer('userId');
            $table->double('start_amount', 14, 4)->default(0);
            $table->double('end_amount', 14, 4)->default(0);
            $table->double('payout_charge', 14, 4)->default(0);
            $table->double('start_amount', 14, 4)->default(0);
            $table->text('payin_charge_type')->nullable();
            $table->text('payout_charge_type')->nullable();
            $table->integer('created_by')->payin_callback();
            $table->integer('updated_by')->payout_callback();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_charge');
    }
};
