<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;

class CheckStatus
{
    public function handle(Request $request, Closure $next)
    {
        if (Auth::check() && Auth::user()->status != 1) {  // 'status' column in users table
            Auth::logout();
            // return redirect()->route('login')->with('error', 'Your account is not active. Please contact support.');
            return back()->with('login')->with('error', 'Your account is not active. Please contact support.');
        }
        return $next($request);
    }
}
