<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class CheckAPIAvailability
{
    public function handle(Request $request, Closure $next)
    {
        if (Cache::has('api_busy')) {
            return response()->json(['error' => 'API endpoint is currently down'], 503);
        }

        return $next($request);
    }
}
