<?php

namespace App\Http\Controllers\API\WAAYUPAY;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Carbon;
use App\Models\User;
use App\Models\UserCharge;
use App\Models\UserIp;
use App\Models\UserTransaction;
use App\Models\PayinModel;
use App\Models\PayoutModel;
use App\Models\ApiLog;
use Illuminate\Support\Facades\Http;
use Illuminate\Http\Client\RequestException;

class Waayupayout extends Controller
{
    public function generateToken()
{   

    $curl = curl_init();
    
     $email = 'abhishekchanchal133@gmail.com'; 
    $password = 'Shahrukh@123$$'; 

curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://payout.waayupay.com/api/login',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS => http_build_query(array('email' => $email, 'password' => $password)),
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/x-www-form-urlencoded'
  ),
    CURLOPT_SSL_VERIFYPEER => false, 
));

$response = curl_exec($curl);


    if ($response === false) {
        $error = curl_error($curl);
        echo 'Curl error: ' . $error;
        curl_close($curl);
        return ['error' => 'Curl request failed'];
    }

    curl_close($curl);

    //echo $response; 

    $responseData = json_decode($response, true);

    if ($responseData === null && json_last_error() !== JSON_ERROR_NONE) {
        $error = 'JSON decoding error: ' . json_last_error_msg();
        echo 'Token retrieval error: ' . $error;
        return ['error' => 'Failed to parse API response'];
    }

    if (isset($responseData['token'])) {
        return $responseData['token']; 
    } else {
        $error = isset($responseData['error']) ? $responseData['error'] : 'Unknown error';
        echo 'Token retrieval error: ' . $error;
        return ['error' => 'Token not found in API response'];
    }
}

    
 
    public function doPayout(Request $request)
    {
        $jsonData = $request->json()->all();        
        $AuthKey = $request->header('AuthKey');  
        $AuthToken = $request->header('AuthToken');
        $AuthCode = $request->header('AuthCode');

        $token = $this->generateToken(); 

        if (isset($token['error'])) {
            return response()->json(['error' => $token['error']], 500);
        }

    
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            //'email' => 'required',
            'mobile' => 'required',
            //'userKey' => 'required',
            //'password' => 'required',
            'bankName' => 'required',
            'accountNumber' => 'required',
            'amount' => 'required',
             'contactid' => 'required',
              'ifscCode' => 'required',
        ]);

        if($validator->fails()) {
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => $validator->errors(),
            ];
            return response()->json($responseData, 422);
        }

        $getUser = User::where("user_token",$AuthToken)->where("user_key",$AuthKey)->where("status",1)->where("api_status",1)->where("user_type",1)->where("approved",1)->first();
        if(empty($getUser)){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'Invalid credentials',
            ];
            return response()->json($responseData , 401);
        }
        if (Hash::check($AuthCode, $getUser->authCode)) {

        }else{
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'Invalid credentials!',
            ];
            return response()->json($responseData , 401);
            die;
        }
        $userId = $getUser->id;
        $api_status = $getUser->api_status;
        if($api_status == 0){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'We are taking downtime due to some technical issues. Please wait till further update',
            ];
            return response()->json($responseData , 200);die;
        }
        $bank_deactive = $getUser->bank_deactive;
        if($bank_deactive == 1){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'Your API has been Deactivated by the Bank due to security reasons.',
            ];
            return response()->json($responseData , 200);die;
        }
        $tecnical_issue = $getUser->tecnical_issue;
        if($tecnical_issue == 1){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'We are facing technical issue from bank side.',
            ];
            return response()->json($responseData , 200);die;
        }

        $iserveu = $getUser->iserveu;
        if($iserveu != 1){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'This service is not active at this time. please use ICICI bank api.',
            ];
            return response()->json($responseData , 200);die;
        }

        $ipAddress = $request->ip();
        $checkIp = UserIp::where(['userId'=>$userId,'ipAddress'=>$ipAddress])->first();
        if(empty($checkIp)){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'your ip is not whitlisted, requested ip is '.$ipAddress,
            ];
            return response()->json($responseData , 401);
        }

       // $contactid = "SSPY".rand(123121,990999).Carbon::now()->timestamp;
        $name = $request['name'];
        //$email = $request['email'];
         $mobile = $request['mobile'];
          // $userKey = $request['userKey'];
            //$password = $request['password'];
             $bankName = $request['bankName'];
       $accountNumber = $request['accountNumber'];
        $transferAmount = $request['amount'];
           $contactid = $request['contactid'];
       $ifscCode = $request['ifscCode'];
      

        if($userId != 29)
        {
            if($ifscCode == "AIRP0000001" || $ifscCode == "PYTM0123456")
            {
                $responseData = [                
                    'status' => FALSE,
                    'error'=> TRUE,
                    'message' => 'Transaction not allowed in this bank',
                ];
                return response()->json($responseData , 401);
                die;
            }
        }
        
        $getCommission = UserCharge::where('start_amount', '<=', $transferAmount)->where('end_amount', '>=', $transferAmount)->where('userId', '=', $userId)->first();
        if(empty($getCommission)){
            $charge = 20;
            $chargeType = "F";
        }else{
            $charge = $getCommission->payout_charge;
            $chargeType = $getCommission->payout_charge_type;
        }
        $gst = 18;
        if($chargeType == "F"){
            $totalCharge = $charge;
            $totalGst = ($totalCharge*$gst)/100;
        }else if($chargeType == "P"){
            $totalCharge = ($transferAmount*$charge)/100;
            $totalGst = ($totalCharge*$gst)/100;
        }
        $totalDeductAmount = $transferAmount +$totalCharge+$totalGst;
        $openBal = $getUser->wallet;
        $lien =$getUser->lien;
        $rolling_reserve = $getUser->rolling_reserve;
        $closeBal = $openBal - $totalDeductAmount;                    
        $checkAmount = $totalDeductAmount+$lien+$rolling_reserve;

        if($openBal == 0 || $openBal < $checkAmount){           
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'Insufficient fund',
            ];
            return response()->json($responseData , 200); die;
        }
        
        $UserInstance = new User();
        $UserInstance->deductFund($userId,$totalDeductAmount);

        $remark = "Money Transfer Via Payout ";
        UserTransaction::create([
            'userId' => $userId,
            'txnId' => $contactid,
           // 'orderId' => $referenceNumber,
            'type' => "DEBIT",  
            'operator' => "PAYOUT",
            'openBalance' =>$openBal, 
            'amount' => $totalDeductAmount,
            'walletBalance' =>$closeBal,
            'credit' =>0, 
            'debit' =>$totalDeductAmount,
            "status" => "PENDING",
            'remark' => $remark,   
            'api'=>"WAAYUPAY",
            // 'requestIp' => $ipAddress,          
            'created_by' => $userId,
        ]);

        PayoutModel::create([
            'userId' => $userId,
            'txnId' => $contactid,
            //'orderId' => $referenceNumber,
            'amount' => $transferAmount,
            'charge' =>$totalCharge,   
            'gst'=>$totalGst,
            'totalAmount' => $totalDeductAmount,   
            //'mode'=>$transferMode,
            'beneName' => $name,          
            'beneBank' => $bankName,
            'beneAccount' => $accountNumber,   
            'beneIfsc' => $ifscCode,          
            'status' => "PENDING",
            'api'=>"WAAYUPAY",
            // 'IpAddress' => $ipAddress,
        ]);

      
        
        
        $header = array(
            'Content-Type: application/x-www-form-urlencoded',
            'Accept: application/json',
            'Authorization: Bearer '. $token, );

            //print_r($header);die();

       
   $request = [
    "name" => $name,
    "email"=> "abhishekchanchal133@gmail.com",
    "mobile" => $mobile,
    "userKey" => "TGRzwnKIl26ss6rt",
    "password" => "Shahrukh@123$$",
    "bankName" => $bankName,
    "accountNumber" =>$accountNumber,
    "amount" => $transferAmount,
    "contactid" => $contactid,
    "ifscCode" => $ifscCode,
    
];

// print_r($request);die();

       //$payload = json_encode($request);

       $payload = http_build_query($request);


       // print_r($payload);die();
     
        $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://payout.waayupay.com/api/payout/transaction',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS => $payload,
          CURLOPT_HTTPHEADER => $header,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => false, 
        ));
        
        $response = curl_exec($curl);
         $err = curl_error($curl);

        curl_close($curl);
        
        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            //echo $response;
        }
 
        ApiLog::create([
            'txnId' => $contactid,
            'request' => $payload,
            'response' => $response,  
            'service' => "PAYOUT",
            'service_api' =>"WAAYUPAY",   
        ]);

        $responseData = json_decode($response, true); 
          $error = $responseData['error'];
          
     if ($responseData !== null && is_array($responseData)) {
    if (isset($responseData['status'])) {
        $status = $responseData['status'];

        if (isset($responseData['error'])) {
            $error = $responseData['error'];
            if (isset($error['status'])) {
                $status = $error['status'];
            } }}}
        //$status = $responseData['status'];
        //print_r($response);die();
      
        $error = $responseData['error'];
    $transactionId = $error['txnid'] ?? ''; 
    $clientpayoutid = $error['payoutid'] ?? ''; 
    $clientutr = $error['utr'] ?? ''; 
       

        

      
           if($status == "FAILED"){
            $updateUser = [
                'walletBalance' =>$openBal,
                'status' => "FAILED"
            ];  

            $UserTransaction = new UserTransaction();      
            $UserTransaction->updateUserTxnData($updateUser,$contactid);

            $updatePayout = [
                "contactId"=>$transactionId, 
                "payoutId"=> $clientpayoutid,          
                "status"=>"FAILED",
                "remark"=>$status
            ];                  
            $PayoutModel = new PayoutModel();      
            $PayoutModel->updatePayoutData($updatePayout,$contactid);

            //$user = User::findOrFail($userId);
            $UserInstance = new User();
            $UserInstance->addFund($userId,$totalDeductAmount);

            $responseData = [
                "status" => "FAILED",
                "message" => $status,
                "data" => array(
                    //"payout_ref" => $referenceNumber,
                    "txn_id" => $contactid,
                    "payoutId" => $clientpayoutid,
                ),
            ];
            return response()->json($responseData , 200);
            die;
        }

        if($status == "SUCCESS") {
           // $rrn = $responseData['rrn'];

            $updateUser = [
                'status' => "SUCCESS"
            ];  

            $UserTransaction = new UserTransaction();      
            $UserTransaction->updateUserTxnData($updateUser,$contactid);

            $updatePayout = [
                "contactId"=>$transactionId,
                //"utr"=> $clientutr,
                "payoutId"=> $clientpayoutid,    
                "status"=>"SUCCESS",
               // "remark"=>$statusMessage
            ];                  
            $PayoutModel = new PayoutModel();      
            $PayoutModel->updatePayoutData($updatePayout,$contactid);

            $responseData = [
                "status" => "SUCCESS",
                "message" => $status,
                "data" => array(
                   // "payout_ref" => $referenceNumber,
                    "txn_id" => $contactid,
                   // "bank_ref" => $clientutr,
                      "payoutId"=> $clientpayoutid,    
                ),
            ];
            return response()->json($responseData , 200);
            die;
        }
        
         if($status == "PROCESSING") {
           // $rrn = $responseData['rrn'];
           
            $checkstatusResponse = $this->checkstatus($request);
            $msg = $checkstatusResponse['msg'];
        $error1 = $checkstatusResponse['error'];
       
        $payoutId = $error1['payoutId'] ?? '';
        $payoutStatus = $error1['status'] ?? '';


            $updateUser = [
                'status' => $payoutStatus,
            ];  

            $UserTransaction = new UserTransaction();      
            $UserTransaction->updateUserTxnData($updateUser,$contactid);

            $updatePayout = [
                "contactId"=>$transactionId,
                //"utr"=> $payoutId,
                "payoutId"=> $payoutId,    
                "status"=>$payoutStatus,
              // "remark"=>$statusMessage
            ];                  
            $PayoutModel = new PayoutModel();      
            $PayoutModel->updatePayoutData($updatePayout,$contactid);

            $responseData = [
                "status" => $payoutStatus,
                "message" => $msg,
                "data" => array(
                  // "payout_ref" => $referenceNumber,
                    "txn_id" => $contactid,
                    //"bank_ref" => $clientutr,
                      "payoutId"=> $payoutId,    
                ),
            ];
            return response()->json($responseData , 200);
            die;
        }
       
        $responseData = [
          
            "status" => $status,
            "message" => $error,
            "data" => array(
               
                "txn_id" => $contactid,
                "bank_ref" => "",
               
            ),
        ];
        return response()->json($responseData , 200);
        die;
    }
    
      public function checkstatus(Request $request){
          
        
        //  echo "Token in checkstatus: " . $token . "\n";
        //  echo "txnrefid in checkstatus: " . $request . "\n";
        
         $token = $this->generateToken(); 

        if (isset($token['error'])) {
            return response()->json(['error' => $token['error']], 500);
        }

        $validator = Validator::make($request->all(), [
            'txnrefid' => 'required',
            
        ]);

        if($validator->fails()) {
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => $validator->errors(),
            ];
            return response()->json($responseData, 422);
        }

        $txnrefid = $request['txnrefid'];
        $curl = curl_init();

        $header = array(
            'Content-Type: application/x-www-form-urlencoded',
            'Accept: application/json',
            'Authorization: Bearer '. $token, );

           
        
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://payout.waayupay.com/api/payout/txn/status/check',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS =>http_build_query(['txnrefid' => $txnrefid]),
          CURLOPT_HTTPHEADER => $header,
           CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => false, 
        ));
        
        $response = curl_exec($curl);
        
       if ($response === false) {
        $responseData = [
            'status' => false,
            'error' => true,
            'message' => 'cURL Error: ' . curl_error($curl),
        ];
        return response()->json($responseData, 500);
    }

    curl_close($curl);
    
    // Process and return the response
    return response()->json(json_decode($response), 200);
        
    }
    
     public function paymonkcallback(Request $request)
    {
        $jsonData = $request->json()->all();   
        print_r($jsonData);
        if(empty($jsonData)){
            echo '{"status": 1,"statusDesc": "Failure"}';die;
        }

        echo '{"status": 0,"statusDesc":"success"}';
        die; 
        
        
    }
    
    
public function refund(Request $request){
    
     $jsonData = $request->json()->all();        
        $Authorization = $request->header('Authorization');

     $getUser = User::where("user_token",$Authorization)->where("status",1)->where("api_status",1)->where("user_type",1)->first();
     
        if(empty($getUser)){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'Invalid credentials.',
            ];
            return response()->json($responseData , 401); die;
        }
    
     $userId = $getUser->id;
     $referenceNumber = $request['referenceNumber'];
        $checkTxn = PayoutModel::where("orderId",$referenceNumber)->where("userId",$userId)->where("api","Haoda")->get()->toArray();
        if(count($checkTxn) == 0){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'Transaction not found.',
            ];
            return response()->json($responseData , 200); die;
        }
        
         $txnID = $checkTxn[0]['txnId'];
        $refundid = "REF".$txnID;
         $refundtxn = UserTransaction::where("refundId",$refundid)->where("userId",$userId)->get()->toArray();
        
         if (!empty($refundtxn)) {
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'Already refunded.',
            ];
            return response()->json($responseData , 200); die;
        }

            

        $ipAddress = $request->ip();
        $totalDeductAmount = $checkTxn[0]['totalAmount'];
            $openBal = $getUser->wallet;

            $closeBal = $openBal + $totalDeductAmount;
            $UserInstance = new User();
            $UserInstance->addFund($userId,$totalDeductAmount);
           
            UserTransaction::create([
                'userId' => $userId,
                'txnId' => $txnID,
                'orderId' => $referenceNumber,
                'type' => "CREDIT",
                'operator' => "REFUND",
                'openBalance'=>$openBal,
                'amount' => $totalDeductAmount,
                'walletBalance' =>$closeBal,  
                'credit' =>$totalDeductAmount, 
                'debit' =>0, 
                'remark' => "Refund against failed transaction",   
                'api'=>"FLIPZIK",
                'status'=>"REFUNDED",
                'requestIp' => $ipAddress,
                "refundId"=>"REF".$txnID,    
                'created_by' => 1,
            ]);

}


    
    
}
