<?php

namespace App\Http\Controllers\API\PAYOUT;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Carbon;
use App\Models\User;
use App\Models\UserCharge;
use App\Models\UserIp;
use App\Models\UserTransaction;
use App\Models\PayinModel;
use App\Models\PayoutModel;
use App\Models\ApiLog;
use Illuminate\Support\Facades\Http;
use Illuminate\Http\Client\RequestException;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;

class PayoutfController extends Controller
{
     public function transferflipfundold1(Request $request){
         
        $secret = "69882b0eafa337d0620fff098342cc00";
        $access_key = "d39b1b5a87d02f7e315d8452a4960e45";
        
       function calculate_hmac($secret, $timestamp, $body, $path, $query_string = '', $method = 'GET'){
           $message = $method."\n".$path."\n".$query_string."\n".$body."\n".$timestamp."\n";
            return hash_hmac('sha512', $message, $secret);
       }
       
       
        $url = "https://api.flipzik.com";
        $fields = array(
              'address'              => "NOIDA SECTOR-12",
              'payment_type'         => 3,
               'amount'               => 100,
               'email'                => "abc@gmail.com",
               'name'                 => "ABC",
               'mobile_number'        => "9999999999",
               'account_number'       => "1348455828",
               'ifsc_code'            => "KKBK0005047",
               'merchant_order_id'    => "testing1234"
              );
        $recorddata = json_encode($fields);
         $x_timestamp  = floor(microtime(true) * 1000);
         $path = "/api/v1/payout/process";
        $signature = calculate_hmac($secret, $x_timestamp, $recorddata, $path, '', 'POST');
        //echo "Signature: " . $signature . "\n";
       // echo $x_timestamp;
          $header_data = array(
              "Content-Type: application/json",
               "User-Agent: team testing",
               "access_key:" . $access_key,
               "signature:" . $signature,
                "X-Timestamp:" . $x_timestamp,
                );
       $ch = curl_init();
       curl_setopt($ch, CURLOPT_URL, $url . $path); // Ensure the path is appended to the URL
       curl_setopt($ch, CURLOPT_POST, true);
       curl_setopt($ch, CURLOPT_POSTFIELDS, $recorddata);
       curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
       curl_setopt($ch, CURLOPT_HTTPHEADER, $header_data);
       curl_setopt($ch, CURLOPT_HEADER, true); // Get headers along with body
       $response = curl_exec($ch);
       echo $response;
       if ($response === false) {
           echo "cURL Error: " . curl_error($ch);
           curl_close($ch);
           exit;
         }
// Separate headers and body
      $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
      $header = substr($response, 0, $header_size);
      $body = substr($response, $header_size);
      curl_close($ch);
// Check content type from headers
        if (preg_match('/Content-Type:\s*application\/json/i', $header)) {
    // Decode JSON response
         $response_data = json_decode($body, true);
         echo "Response JSON:\n";
        print_r($response_data);
         } else {
    // Print plain text response
        echo "Response Text:\n";
        echo $body;
         
    }}
    
    
    
    
    
    public function transferflipfund(Request $request){
        
           Log::info('Transfer fund request received', [
        'request_data' => $request->all()
    ]);


        $jsonData = $request->json()->all();  
       $AuthKey = $request->header('AuthenticatedKeyId');  
        $AuthToken = $request->header('AuthenticatedToken');
        $AuthCode = $request->header('AuthenticatedCode');
        

 
        $validator = Validator::make($request->all(), [
        'name' => 'required|string',
        'mobileNumber' => 'required',
        'referenceNumber' =>'required', // |unique:payout_transactions,orderId
       'transferAmount' => 'required|max:49000',
        'transferMode' => 'required',
        
    ]);


    if($validator->fails()) {
        
        Log::error('Validation failed', [
        'errors' => $validator->errors()->toArray(),
    ]);
        $responseData = [                
            'status' => FALSE,
            'error'=> TRUE,
            'message' => $validator->errors(),
        ];
        return response()->json($responseData, 422);
        
    }
        
      

        $getUser = User::where("user_token",$AuthToken)->where("user_key",$AuthKey)->where("status",1)->where("api_status",1)->where("user_type",1)->where("approved",1)->first();
        $address = $getUser->city;
        if(empty($getUser)){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'Invalid credentials',
            ];
            return response()->json($responseData , 401);
        }
        if (Hash::check($AuthCode, $getUser->authCode)) {

        }else{
            
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'Invalid credentials!',
            ];
            return response()->json($responseData , 401);
            die;
        }
        $userId = $getUser->id;
        $api_status = $getUser->api_status;
        if($api_status == 0){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'We are taking downtime due to some technical issues. Please wait till further update',
            ];
            return response()->json($responseData , 200);die;
        }
        $bank_deactive = $getUser->bank_deactive;
        if($bank_deactive == 1){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'Your API has been Deactivated by the Bank due to security reasons.',
            ];
            return response()->json($responseData , 200);die;
        }
        $tecnical_issue = $getUser->tecnical_issue;
        if($tecnical_issue == 1){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'We are facing technical issue from bank side.',
            ];
            return response()->json($responseData , 200);die;
        }

      

       $ipAddress = $request->ip();
        $checkIp = UserIp::where(['userId'=>$userId,'ipAddress'=>$ipAddress])->first();
        if(empty($checkIp)){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'your ip is not whitlisted, requested ip is '.$ipAddress,
            ];
            return response()->json($responseData , 401);die; }
            
    $referenceNumber =$request['referenceNumber'];
    $merchantId = "SEOS".rand(123121,990999).Carbon::now()->timestamp;
    $name = $request['name'];
    $mobile = $request['mobileNumber'];
    $transferAmount = $request['transferAmount'];
     $transfermode = $request['transferMode'];
      $accountNumber = $request['accountNumber'];
      $ifscCode = $request['bankIfsc'];
      $bankname= $request['beneBankName'];
     // $checkaccountno = $request['reenter_accno'];
      $vpa = $request['vpa'];
    
    //$transferAmountinpaisa=$transferAmount * 100; 

         $transfer = floatval($transferAmount); 
           $transferAmountinpaisa = intval($transfer * 100);
        
        if($transfermode == 'IMPS') {
            if($getUser->IMPS == 1) {

                $validator = Validator::make($request->all(), [
                    'accountNumber' => 'required|string|digits_between:6,20',
                    'bankIfsc' => 'required|string',
                    'beneBankName' => 'required|string',
                   
                ]);
    
                if ($validator->fails()) {
                    $responseData = [
                        'status' => FALSE,
                        'error' => TRUE,
                        'message' => $validator->errors(),
                    ];
                    return response()->json($responseData, 422);
                }
                
                 $fields = [
        "name" => $name,
        //  "email" => "shikuldigitalservices@gmail.com",
         "email" => "abhishekchanchal133@gmail.com",
        "mobile_number" => $mobile,
        "address" => $address,
        "payment_type" => 3,
        // "bank_name" => $bankname,
        "account_number" => $accountNumber,
        "amount" => $transferAmountinpaisa,
        "merchant_order_id" => $merchantId,
        "ifsc_code" => $ifscCode
    ];
     
            }else {
                $responseData = [
                    'status' => FALSE,
                    'error'=> TRUE,
                    'message' => 'IMPS not permitted',
                ];
                return response()->json($responseData, 200);die;
            }}
         
        elseif($transfermode == 'UPI') {
            if($getUser->UPI == 1) {

                $validator = Validator::make($request->all(), [
                    'vpa' => 'required|string',
                ]);
    
                if ($validator->fails()) {
                    $responseData = [
                        'status' => FALSE,
                        'error' => TRUE,
                        'message' => $validator->errors(),
                    ];
                    return response()->json($responseData, 422);
                }
                
                  $fields = [
           "name" => $name,
        // "email" => "shikuldigitalservices@gmail.com",
         "email" => "abhishekchanchal133@gmail.com",
        "mobile_number" => $mobile,
        "address" => $address,
        "payment_method" =>2,
        // "bank_name" => "Yes Bank",
        "account_number" =>  $vpa,
        "amount" => $transferAmountinpaisa,
        "merchant_order_id" => $merchantId,
        "ifsc" => " "
        ];
        
    }
    
     else {
                $responseData = [
                    'status' => FALSE,
                    'error'=> TRUE,
                    'message' => 'UPI not permitted',
                ];
                return response()->json($responseData, 200);die;
            }
        } 
        else {
            $responseData = [
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'Invalid transfer mode',
            ];
            return response()->json($responseData, 200);
            die;
        }
        
         DB::beginTransaction();

        try {
            $getUser = DB::table('users')->where('id', $getUser->id)->lockForUpdate()->first();
        
        $getCommission = UserCharge::where('start_amount', '<=', $transferAmount)->where('end_amount', '>=', $transferAmount)->where('userId', '=', $userId)->first();
        if(empty($getCommission)){
            $charge = 20;
            $chargeType = "F";
        }else{
            $charge = $getCommission->payout_charge;
            $chargeType = $getCommission->payout_charge_type;
        }
        $gst = 18;
        if($chargeType == "F"){
            $totalCharge = $charge;
            $totalGst = ($totalCharge*$gst)/100;
        }else if($chargeType == "P"){
            $totalCharge = ($transferAmount*$charge)/100;
            $totalGst = ($totalCharge*$gst)/100;
        }
        $totalDeductAmount = $transferAmount +$totalCharge+$totalGst;
        $openBal = $getUser->wallet;
        $lien =$getUser->lien;
        $rolling_reserve = $getUser->rolling_reserve;
        $closeBal = $openBal - $totalDeductAmount;                    
        $checkAmount = $totalDeductAmount+$lien+$rolling_reserve;

        if($openBal == 0 || $openBal < $checkAmount){  
             DB::rollBack();   
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'Insufficient fund',
            ];
            return response()->json($responseData , 200);
            die;
        }
        
        $UserInstance = new User();
        $UserInstance->deductFund($userId,$totalDeductAmount);

        $remark = "Money Transfer Via Payout ";
        UserTransaction::create([
            'userId' => $userId,
            'txnId' => $merchantId,
             'orderId' => $referenceNumber,
            'type' => "DEBIT",  
            'operator' => "PAYOUT",
            'openBalance' =>$openBal, 
            'amount' => $totalDeductAmount,
            'walletBalance' =>$closeBal,
            'credit' =>0, 
            'debit' =>$totalDeductAmount,
            "status" => "PENDING",
            'remark' => $remark,   
            'api'=>"FLIPZIK_M",
            'requestIp' => $ipAddress,          
            'created_by' => $userId,
        ]);

        PayoutModel::create([
            'userId' => $userId,
            'txnId' => $merchantId,
            'orderId' => $referenceNumber,
            'amount' => $transferAmount,
            'charge' =>$totalCharge,   
            'gst'=>$totalGst,
            'totalAmount' => $totalDeductAmount,   
            'mode'=>$transfermode,
            'beneName' => $name,          
            'beneBank' => $bankname,
            'beneAccount' => $accountNumber,   
            'beneIfsc' => $ifscCode,          
            'status' => "PENDING",
            'api'=>"FLIPZIK_M",
            'IpAddress' => $ipAddress,
            'mobile' =>$mobile,
            'contactId' => $vpa,
        ]);
        
        DB::commit();
        
        
      $amountcheck = intval($transferAmount);

      if ($amountcheck % 1000 == 0 && ($ifscCode == "IPOS0000001" || $ifscCode == "AIRP0000001")) {
       

                  $updateUser = [
                'status' => "FAILED"
            ];  

            $UserTransaction = new UserTransaction();      
            $UserTransaction->updateUserTxnData($updateUser,$merchantId);

            $updatePayout = [
                "status"=>"FAILED",
                 "remark"=>"FAILED"
            ];                  
            $PayoutModel = new PayoutModel();      
            $PayoutModel->updatePayoutData($updatePayout,$merchantId);

        
        $responseData = [
                "status" => "FAILED",
                "message" => "Transaction is Failed",
                "data" => array(
                  "payout_ref" => $referenceNumber,
                    "txn_id" => $merchantId,
                    "bank_ref" => ""
                ),
            ];
            DB::commit();
            return response()->json($responseData, 200);die;
         }
         
         
         
         
         $button_1 = $getUser->button_1;
          if ($button_1 == 1) {

            $updatePayout = [
                "button"=>"pending1",
                 
            ];                  
            $PayoutModel = new PayoutModel();      
            $PayoutModel->updatePayoutData($updatePayout,$merchantId);

        
        $responseData = [
                "status" => "Pending",
                "message" => "Transaction is Pending",
                "data" => array(
                  "payout_ref" => $referenceNumber,
                    "txn_id" => $merchantId,
                    "bank_ref" => ""
                ),
            ];
            DB::commit();
            return response()->json($responseData, 200);die;
         }
         
         
         
         
           $button_2 = $getUser->button_2;
          if ($button_2 == 1) {
         
$apiRequestCount = DB::table('api_request_count')->where('user_id', $userId)->first();

if (!$apiRequestCount) {
   
    DB::table('api_request_count')->insert([
        'user_id' => $userId,
        'request_count' => 1
    ]);
    $currentCount = 1;
} else {
  
    $currentCount = $apiRequestCount->request_count + 1;
  
    $updateResult = DB::table('api_request_count')->where('user_id', $userId)->update(['request_count' => $currentCount]);
   
}
    if ($currentCount % 4 === 0) {
       
        DB::table('api_request_count')->where('user_id', $userId)->update(['request_count' => 0]);

           $updatePayout = [
                "button"=>"pending2",
                 
            ];  
            
            $PayoutModel = new PayoutModel();      
            $PayoutModel->updatePayoutData($updatePayout,$merchantId);
            
           $responseData = [
                "status" => "Pending",
                "message" => "Transaction is Pending",
                "data" => array(
                  "payout_ref" => $referenceNumber,
                    "txn_id" => $merchantId,
                    "bank_ref" => ""
                ),
            ];
            DB::commit();
            return response()->json($responseData, 200);die;
        
     
    }}
    
 
    
    
    
$button3_value = $getUser->button3_value; 
$button_3 = $getUser->button_3;

if ($button_3 == 1) {
    $pendingRequestsLimit = 2; 
    $processedRequestsLimit = $button3_value + $pendingRequestsLimit;

   
    $apiRequestCount = DB::table('api_request_count')->where('user_id', $userId)->first();
    if (!$apiRequestCount) {
        DB::table('api_request_count')->insert([
            'user_id' => $userId,
            'request_count' => 1
        ]);
        $currentCount = 1;
    } else {
        $currentCount = $apiRequestCount->request_count + 1;
        DB::table('api_request_count')->where('user_id', $userId)->update(['request_count' => $currentCount]);
    }

  
    $requestsInCycle = $currentCount % $processedRequestsLimit;
   
   
    if ($requestsInCycle >= $button3_value ) {
       
        if ($requestsInCycle == $processedRequestsLimit - 1 ) {
            DB::table('api_request_count')->where('user_id', $userId)->update(['request_count' => 0]);
        }

         $updatePayout = [
                "button"=>"pending3",
                 
            ];  
            
            $PayoutModel = new PayoutModel();      
            $PayoutModel->updatePayoutData($updatePayout,$merchantId);
            
           $responseData = [
                "status" => "Pending",
                "message" => "Transaction is Pending",
                "data" => array(
                  "payout_ref" => $referenceNumber,
                    "txn_id" => $merchantId,
                    "bank_ref" => ""
                ),
            ];
            DB::commit();
            return response()->json($responseData, 200);die;
    }

    
}


        // $secret = "69882b0eafa337d0620fff098342cc00";
        // $access_key = "d39b1b5a87d02f7e315d8452a4960e45";
        
        $access_key = "0fb85bce09ed69c8d1997f61a74cd4a1";
        $secret = "37f1811df51159de7638fd155809634c";
        
       function calculate_hmac($secret, $timestamp, $body, $path, $query_string = '', $method = 'GET'){
           $message = $method."\n".$path."\n".$query_string."\n".$body."\n".$timestamp."\n";
            return hash_hmac('sha512', $message, $secret);
       }
       
       
        $url = "https://api.flipzik.com";
        $path = "/api/v1/payout/process";
        $recorddata = json_encode($fields);
         $x_timestamp  = floor(microtime(true) * 1000);
        $signature = calculate_hmac($secret, $x_timestamp, $recorddata, $path, '', 'POST');
        //echo "Signature: " . $signature . "\n";
       // echo $x_timestamp;
          $header_data = array(
              "Content-Type: application/json",
               "User-Agent: team testing",
               "access_key:" . $access_key,
               "signature:" . $signature,
                "X-Timestamp:" . $x_timestamp,
                );
                
              //print_r($header_data);
   $ch = curl_init();

curl_setopt_array($ch, array(
    CURLOPT_URL => $url . $path,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'POST',
    CURLOPT_POSTFIELDS => $recorddata,
    CURLOPT_HTTPHEADER => $header_data,
    CURLOPT_HEADER => true, // Include headers in response
));

$response = curl_exec($ch);

Log::info('cURL Response: ' . $response);


if ($response === false) {
    echo "cURL Error: " . curl_error($ch);
    curl_close($ch);
    exit;
}

// Separate headers and body
$header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
$header = substr($response, 0, $header_size);
$body = substr($response, $header_size);


curl_close($ch);

 ApiLog::create([
            'txnId' => $merchantId,
            'request' => $recorddata,
            'response' => $response,  
            'service' => "PAYOUT",
            'service_api' =>"FLIPZIK",   
        ]);
        
          DB::commit();

if (preg_match('/Content-Type:\s*application\/json/i', $header)) {
    
    $responseData = json_decode($body, true);
    dd($responseData);

        
        $data = isset($responseData['data'])?$responseData['data']:'';
      

        $status = isset($data['status'])?$data['status'] : ''; 
        $clientgatewayid = isset($data['id'])?$data['id'] : ''; 
        $clientutr = isset($data['bank_reference_id'] )?$data['bank_reference_id'] :''; 
        

     
          if($status == "Failed" || $status == "Reversed" || $status == "Rejected"){
            $updateUser = [
                //'walletBalance' =>$openBal,
                'status' => "FAILED"
            ];  

            $UserTransaction = new UserTransaction();      
            $UserTransaction->updateUserTxnData($updateUser,$merchantId);

            $updatePayout = [
                "payoutId"=> $clientgatewayid,  
                 "utr"=> $clientutr,
                "status"=>"FAILED",
               
            ];                  
            $PayoutModel = new PayoutModel();      
            $PayoutModel->updatePayoutData($updatePayout,$merchantId);

            //$user = User::findOrFail($userId);
            $UserInstance = new User();
            $UserInstance->addFund($userId,$totalDeductAmount);

            
              $responseData = [
                "status" => "FAILED",
                "message"=>"Transaction is Failed",
                "data" => array(
                    "payout_ref" => $referenceNumber,
                    "txn_id" => $merchantId,
                    "bank_ref" => $clientutr,
                ),
            ];
            DB::commit();
            return response()->json($responseData, 200);
        }

        if($status == "Success") {
         

            $updateUser = [
                'status' => "SUCCESS"
            ];  

            $UserTransaction = new UserTransaction();      
            $UserTransaction->updateUserTxnData($updateUser,$merchantId);

            $updatePayout = [
                
                "utr"=> $clientutr,
                "payoutId"=> $clientgatewayid,    
                "status"=>"SUCCESS",
                
              // "remark"=>$statusMessage
            ];                  
            $PayoutModel = new PayoutModel();      
            $PayoutModel->updatePayoutData($updatePayout,$merchantId);

        
        $responseData = [
                "status" => "SUCCESS",
                "message" => "Transaction is Successful",
                "data" => array(
                  "payout_ref" => $referenceNumber,
                    "txn_id" => $merchantId,
                    "bank_ref" => $clientutr
                ),
            ];
            DB::commit();
            return response()->json($responseData, 200);
        }
        
          if($status == "Pending" || $status == "Initiated") {
              
               $updatePayout = [
                "payoutId"=> $clientgatewayid,    

            ];                  
            $PayoutModel = new PayoutModel();      
            $PayoutModel->updatePayoutData($updatePayout,$merchantId);
     
         $responseData = [
                "status" => "Pending",
                 "message" => "Transaction is Pending",
                "data" => array(
                  "payout_ref" => $referenceNumber,
                    "txn_id" => $merchantId,
                    "bank_ref" => ""
                ),
            ];
            DB::commit();
            return response()->json($responseData, 200);
          }
          
        } }
        
     catch (\Exception $e) {
       
        Log::error('Transaction rollback', [
            'userId' => $getUser->id ?? null,
            'requestData' => $request->all(),
            'exceptionMessage' => $e->getMessage(),
            'exceptionTrace' => $e->getTraceAsString(),
            'timestamp' => now(),
        ]);
        
         DB::commit();
       // DB::rollBack();
         
          
        return response()->json([
            'status' => FALSE,
            'error' => TRUE,
            'message' => 'Transaction failed. Please try again.',
           // 'exceptionMessage' => $e->getMessage(),
        ], 500);
    }
   
        }
        
        
    
    



public function callbackurl(Request $request){
   
$jsonData = $request->json()->all();

Log::info('Incoming callback data: ' . json_encode($jsonData));

$data = $jsonData['data']['object'] ?? [];

    //Extract status and utr from the data
   $status = $data['status'] ?? null;
    $utr = isset($data['bank_reference_id'])?$data['bank_reference_id'] : null;
    $merchantId = isset($data['merchant_order_id'])?$data['merchant_order_id']:null;
    $clientgatewayidcallback = isset($data['id'])?$data['id'] :null;
    
      $apiLog = ApiLog::where('txnId', $merchantId)->first();
      if ($apiLog) {
            $apiLog->callback = json_encode($jsonData);
            $apiLog->save();}
            
  
         
          DB::beginTransaction();
    try {
        $pendingPayout = PayoutModel::where('txnId', $merchantId)->lockForUpdate()->first();
 
     $pendingstatus =    $pendingPayout->status;
     
     if($pendingstatus=="PENDING"){

        $userTransaction = UserTransaction::where('txnId', $merchantId)->lockForUpdate()->first();
       
         
         if($status == "Failed" || $status == "Reversed" || $status == "Rejected"){
              
      
            //$userId = $userTransaction->userId;
          // $openBal = $userTransaction->openBalance;
            
     // $totalDeductAmount = $userTransaction->debit;
            
            $updateUser = [
                //'walletBalance' =>$openBal,
                'status' => "FAILED",
                 'updated_at' => now()
            ];  

            $UserTransaction = new UserTransaction();      
            $UserTransaction->updateUserTxnData($updateUser,$merchantId);

            $updatePayout = [
                "payoutId"=> $clientgatewayidcallback,          
                "status"=>"FAILED",
                 "utr"=> $utr,
                  "updated_at" => now()
                
            ];                  
            $PayoutModel = new PayoutModel();      
            $PayoutModel->updatePayoutData($updatePayout,$merchantId);

            //$user = User::findOrFail($userId);
            // $UserInstance = new User();
            // $UserInstance->addFund($userId,$totalDeductAmount);
           
        }
        

        if($status == "Success") {
         
            $updateUser = [
                'status' => "SUCCESS",
                 'updated_at' => now()
            ];  

            $UserTransaction = new UserTransaction();      
            $UserTransaction->updateUserTxnData($updateUser,$merchantId);

            $updatePayout = [
                
                "utr"=> $utr,
                "payoutId"=> $clientgatewayidcallback,    
                "status"=>"SUCCESS",
                "updated_at" => now()
              
            ];                  
            $PayoutModel = new PayoutModel();      
            $PayoutModel->updatePayoutData($updatePayout,$merchantId);
}

}
DB::commit();
} catch (\Exception $e) {
  DB::commit();
    Log::error('Callback error: ' . $e->getMessage());
      //DB::rollBack();
}

         $this->callbackurlgive($request);
}

public function callbackurlgive(Request $request){
    
     $jsonData = $request->json()->all();

    Log::info('Incoming callback data2: ' . json_encode($jsonData));

  
   $data = $jsonData['data']['object'] ?? [];
   
    $status = $data['status'] ?? null;
    $utr = isset($data['bank_reference_id'])?$data['bank_reference_id'] : null;
    $merchantId = isset($data['merchant_order_id'])?$data['merchant_order_id']:null;
    $amount = $data['amount'] ?? null;
    
     $userTransaction = UserTransaction::where('txnId', $merchantId)->first();
      if ($userTransaction){

    $orderid = $userTransaction->orderId;

     
    $responseData = [
        "amount" => $amount,
        "merchant_order_id" => $merchantId,
        "Reference_id" => $orderid,
        "status" => $status,
        "utr" => $utr,
      
    ];

   
   // Log::info('Response data: ' . json_encode($responseData));

    
    $finalResponse = [
        "data" => $responseData,
    ];

    
   // Log::info('Final response: ' . json_encode($finalResponse));

   
    
        $userId = $userTransaction->userId;
        $user = User::find($userId);

        
        if ($user && $user->payout_callback) {
            $userURL = $user->payout_callback;

            
            $response = Http::post($userURL, $finalResponse);

           
            Log::info('Response sent to user URL: ' . json_encode($finalResponse));
            Log::info('Response body from user URL: ' . $response->body());
        }
        else{
            Log::info('no callback url found');
        }
    }
}
    
     


  public function checkStatus(Request $request){

        $jsonData = $request->json()->all();        
        $Authorization = $request->header('Authorization');

        $validator = Validator::make($request->all(), [
            'referenceNumber' => 'required',            
        ]);

        if($validator->fails()) {
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => $validator->errors(),
            ];
            return response()->json($responseData, 422); die;
        }

        $getUser = User::where("user_token",$Authorization)->where("status",1)->where("api_status",1)->where("user_type",1)->first();
        if(empty($getUser)){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'Invalid credentials.',
            ];
            return response()->json($responseData , 401); die;
        }

        $userId = $getUser->id;
        $ipAddress = $request->ip();
        // $checkIp = UserIp::where(['userId'=>$userId,'ipAddress'=>$ipAddress])->first();
        // if(empty($checkIp)){
        //     $responseData = [                
        //         'status' => FALSE,
        //         'error'=> TRUE,
        //         'message' => 'your ip is not whitlisted, requested ip is '.$ipAddress,
        //     ];
        //     return response()->json($responseData , 401);
        // }
        $referenceNumber = $request['referenceNumber'];
        
  
        $checkTxn = PayoutModel::where("orderId",$referenceNumber)->where("userId",$userId)->get()->toArray();
     
        if(empty($checkTxn)){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'Transaction not found.',
            ];
            return response()->json($responseData , 200); die;
        }
        
        $TxnStatus = $checkTxn[0]['status'];
        $TxnApi = $checkTxn[0]['api'];
        $txnId = $checkTxn[0]['txnId'];
         $payoutid = $checkTxn[0]['payoutId'];
      
      
      $access_key = "0fb85bce09ed69c8d1997f61a74cd4a1";
        $secret = "37f1811df51159de7638fd155809634c";
        
       function calculate_hmac($secret, $timestamp, $body, $path, $query_string = '', $method = 'GET'){
           $message = $method."\n".$path."\n".$query_string."\n".$body."\n".$timestamp."\n";
            return hash_hmac('sha512', $message, $secret);
       }
       
       
        $url = "https://api.flipzik.com";
        $path = "/api/v1/payout/$payoutid";
        
     
         $x_timestamp  = floor(microtime(true) * 1000);
        $signature = calculate_hmac($secret, $x_timestamp, '', $path, '', 'GET');
        //echo "Signature: " . $signature . "\n";
       // echo $x_timestamp;
           $header_data = array(
    "Content-Type: application/json",
    "User-Agent:  team testing",
    "access_key:" . $access_key,
    "signature:" . $signature,
    "X-Timestamp:" . $x_timestamp,
);
            
                
              
                
              
   $ch = curl_init();

curl_setopt_array($ch, array(
    CURLOPT_URL => $url . $path,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'GET',
    CURLOPT_HTTPHEADER => $header_data,
    CURLOPT_HEADER => true, // Include headers in response
));

$response = curl_exec($ch);
//print_r($response); 

if ($response === false) {
    echo "cURL Error: " . curl_error($ch);
    curl_close($ch);
    exit;
}

// Separate headers and body
$header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
$header = substr($response, 0, $header_size);
$body = substr($response, $header_size);


curl_close($ch);



    if (preg_match('/Content-Type:\s*application\/json/i', $header)) {
    
    $jsonData = json_decode($body, true);
    
   // print_r($jsonData);

        ApiLog::create([
            'txnId' => $txnId,
            'request' => $referenceNumber,
            'response' => $response,  
            'service' => "CHECKSTATUS",
            'service_api' =>"FLIPZIK",   
        ]);

        if (empty($response)) {
            $response = [
                'status'   => 400,
                'error'    => true,
                'messages' => 'Something went wrong'
            ];
            return $this->respond($response, 400);
        }


    $status = $jsonData['status'] ?? null;
    $utr = $jsonData['bank_reference_id'] ?? null;
    $merchantId = $jsonData['merchant_order_id'] ?? null;
    $clientgatewayidcallback = $jsonData['id'] ?? null;
            
             $pendingPayout = PayoutModel::where('txnId', $merchantId)->first();    
     $pendingstatus = $pendingPayout->status;
     
    
     
     if($pendingstatus=="PENDING"){
          if($status == "Failed" || $status == "Reversed" || $status == "Rejected"){
              
        $userTransaction = UserTransaction::where('txnId', $merchantId)->first();
        if ($userTransaction) {
           // $userId = $userTransaction->userId;
            //$openBal = $userTransaction->openBalance;
            
     // $totalDeductAmount = $userTransaction->debit;
            
            $updateUser = [
                //'walletBalance' =>$openBal,
                'status' => "FAILED",
                 'updated_at' => now()
            ];  

            $UserTransaction = new UserTransaction();      
            $UserTransaction->updateUserTxnData($updateUser,$merchantId);

            $updatePayout = [
                "payoutId"=> $clientgatewayidcallback,          
                "status"=>"FAILED",
                 "utr"=> $utr,
                  "updated_at" => now()
               
            ];                  
            $PayoutModel = new PayoutModel();      
            $PayoutModel->updatePayoutData($updatePayout,$merchantId);

          
            // $UserInstance = new User();
            // $UserInstance->addFund($userId,$totalDeductAmount);
            
           
           
        }
        }

        if($status == "Success") {
         

            $updateUser = [
                'status' => "SUCCESS",
                 'updated_at' => now()
            ];  

            $UserTransaction = new UserTransaction();      
            $UserTransaction->updateUserTxnData($updateUser,$merchantId);

            $updatePayout = [
                
                "utr"=> $utr,
                "payoutId"=> $clientgatewayidcallback,    
                "status"=>"SUCCESS",
                 "updated_at" => now()
              
            ];                  
            $PayoutModel = new PayoutModel();      
            $PayoutModel->updatePayoutData($updatePayout,$merchantId);
        
        
            
    }
    
     }
  $responseData = [
            "status" => $status,
            "message" => "Transaction is $status",
            "data" => array(
                "payout_ref" => $referenceNumber,
                "txnId" => $txnId,
                "bank_ref" => $utr
            ),
        ];
     
       return response()->json($responseData , 200);
  

}
}


private function calculate_hmacccc($secret, $timestamp, $body, $path, $query_string = '', $method = 'POST') {
        $message = $method."\n".$path."\n".$query_string."\n".$body."\n".$timestamp."\n";
        return hash_hmac('sha512', $message, $secret);
    }
       

public function processTransactions(Request $request){
   

//     $merchantId = [ 
// 'SEOS3526941728536063'
//     ];

// $merchantId = DB::table('payout_transactions')
//     ->select('txnId')
//     ->distinct() // Ensure unique txnIds
//     ->where('status', 'pending') // Filter where status is 'pending'
//     ->where('userId', 56) // Filter by userId 56
//     ->where('created_at', 'like', '2024-10-11%') // Use like for date matching
//     ->whereNull('payoutId') // Filter where payout_id is null
//     ->limit(3) // Limit to 100 txnIds
//     ->pluck('txnId') // Get the txnId values as an array
//     ->toArray(); // Convert to array for further use




//     $transactions = DB::table('payout_transactions')
//         ->whereIn('txnId', $merchantId)
//         ->get();

   
//     foreach ($transactions as $transaction) {
      
//          $transfer = floatval($transaction->amount); 
//           $amountInPaisa = intval($transfer * 100);
//         $fields= [
//                 "name" => $transaction->beneName,
//                 "email" => "shikuldigitalservices@gmail.com", // Static value
//                 "mobile_number" => $transaction->mobile,
//                 "address" => "ujjain",
//                 "payment_type" => 3,
//               // "bank_name" => "Yes Bank", // Static value
//                 "account_number" => $transaction->beneAccount,
//                 "amount" => $amountInPaisa,
//                 "merchant_order_id" => $transaction->txnId,
//                 "ifsc_code" => $transaction->beneIfsc, // Static value, adjust as needed
//         ];
        
         
             
//     $secret = "69882b0eafa337d0620fff098342cc00";
//         $access_key = "d39b1b5a87d02f7e315d8452a4960e45";
        
     
       
        // $url = "https://api.flipzik.com";
        // $path = "/api/v1/payout/process";
        // $recorddata = json_encode($fields);
        //  $x_timestamp  = floor(microtime(true) * 1000);
        // $signature = calculate_hmac($secret, $x_timestamp, $recorddata, $path, '', 'POST');
        
        //  $signature = $this->calculate_hmacccc($secret, $timestamp, $body, $path, '', 'POST');
        
        //echo "Signature: " . $signature . "\n";
       // echo $x_timestamp;
//           $header_data = array(
//               "Content-Type: application/json",
//               "User-Agent: team testing",
//               "access_key:" . $access_key,
//               "signature:" . $signature,
//                 "X-Timestamp:" . $x_timestamp,
//                 );
                
              
//   $ch = curl_init();

// curl_setopt_array($ch, array(
//     CURLOPT_URL => $url . $path,
//     CURLOPT_RETURNTRANSFER => true,
//     CURLOPT_ENCODING => '',
//     CURLOPT_MAXREDIRS => 10,
//     CURLOPT_TIMEOUT => 0,
//     CURLOPT_FOLLOWLOCATION => true,
//     CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
//     CURLOPT_CUSTOMREQUEST => 'POST',
//     CURLOPT_POSTFIELDS => $recorddata,
//     CURLOPT_HTTPHEADER => $header_data,
//     CURLOPT_HEADER => true, // Include headers in response
// ));

// $response = curl_exec($ch);

// Log::info('cURL Response: ' . $response);
// print_r($response);

// if ($response === false) {
//     echo "cURL Error: " . curl_error($ch);
//     curl_close($ch);
//     exit;
// }

// // Separate headers and body
// $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
// $header = substr($response, 0, $header_size);
// $body = substr($response, $header_size);


// curl_close($ch);


        // Database query to get merchantIds
        $merchantId = DB::table('payout_transactions')
            ->select('txnId')
            ->distinct() // Ensure unique txnIds
            ->where('status', 'pending') // Filter where status is 'pending'
            ->where('userId', 56) // Filter by userId 56
            ->where('created_at', 'like', '2024-12-03%') // Use like for date matching
            ->whereNull('payoutId') // Filter where payout_id is null
            ->limit(100) // Limit to 3 txnIds (for testing purposes)
            ->pluck('txnId') // Get the txnId values as an array
            ->toArray(); // Convert to array for further use

        // Get the transaction details
        $transactions = DB::table('payout_transactions')
            ->whereIn('txnId', $merchantId)
            ->get();

        foreach ($transactions as $transaction) {
            $transfer = floatval($transaction->amount); 
            $amountInPaisa = intval($transfer * 100);
            $fields = [
                "name" => $transaction->beneName,
              //  "email" => "shikuldigitalservices@gmail.com", // Static value
               "email" => "abhishekchanchal133@gmail.com",
                "mobile_number" => $transaction->mobile,
                "address" => "ujjain",
                "payment_type" => 3,
                "account_number" => $transaction->beneAccount,
                "amount" => $amountInPaisa,
                "merchant_order_id" => $transaction->txnId,
                "ifsc_code" => $transaction->beneIfsc, // Static value, adjust as needed
            ];

            // $secret = "69882b0eafa337d0620fff098342cc00";
            // $access_key = "d39b1b5a87d02f7e315d8452a4960e45";
            
            $access_key = "0fb85bce09ed69c8d1997f61a74cd4a1";
        $secret = "37f1811df51159de7638fd155809634c";

            $url = "https://api.flipzik.com";
            $path = "/api/v1/payout/process";
            $recorddata = json_encode($fields);
            $x_timestamp = floor(microtime(true) * 1000);
            
            // Call the HMAC method
            $signature = $this->calculate_hmacccc($secret, $x_timestamp, $recorddata, $path, '', 'POST');

            $header_data = array(
                "Content-Type: application/json",
                "User-Agent: team testing",
                "access_key: " . $access_key,
                "signature: " . $signature,
                "X-Timestamp: " . $x_timestamp,
            );

            // Make the cURL request
            $ch = curl_init();
            curl_setopt_array($ch, array(
                CURLOPT_URL => $url . $path,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => $recorddata,
                CURLOPT_HTTPHEADER => $header_data,
                CURLOPT_HEADER => true, // Include headers in response
            ));

            $response = curl_exec($ch);
            print_r($response);
            Log::info('cURL Response: ' . $response);

            if ($response === false) {
                echo "cURL Error: " . curl_error($ch);
                curl_close($ch);
                exit;
            }

            // Separate headers and body
            $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
            $header = substr($response, 0, $header_size);
            $body = substr($response, $header_size);

            curl_close($ch);


    ApiLog::create([
        'txnId' => $transaction->txnId, // Log each txnId
        'request' => $recorddata, // The API request payload
        'response' => $response, // The full API response
        'service' => "PAYOUT", // Service name
        'service_api' => "FLIPZIK", // API being used
    ]);


// if (preg_match('/Content-Type:\s*application\/json/i', $header)) {
    
//     $responseData = json_decode($body, true);
//     // echo "Response JSON:\n";
//     // print_r($responseData);

       
        
        
        
//         $data = isset($responseData['data'])?$responseData['data']:'';
      

//         $status = isset($data['status'])?$data['status'] : ''; 
//         $clientgatewayid = isset($data['id'])?$data['id'] : ''; 
//         $clientutr = isset($data['bank_reference_id'] )?$data['bank_reference_id'] :''; 
        

     
//           if($status == "Failed" || $status == "Reversed" || $status == "Rejected"){
//             $updateUser = [
//                 'walletBalance' =>$openBal,
//                 'status' => "FAILED"
//             ];  

//             $UserTransaction = new UserTransaction();      
//             $UserTransaction->updateUserTxnData($updateUser,$merchantId);

//             $updatePayout = [
//                 "payoutId"=> $clientgatewayid,  
//                  "utr"=> $clientutr,
//                 "status"=>"FAILED",
               
//             ];                  
//             $PayoutModel = new PayoutModel();      
//             $PayoutModel->updatePayoutData($updatePayout,$merchantId);

//             //$user = User::findOrFail($userId);
//             $UserInstance = new User();
//             $UserInstance->addFund($userId,$totalDeductAmount);

            
//               $responseData = [
//                 "status" => "FAILED",
//                 "message"=>"Transaction is Failed",
//                 "data" => array(
//                     "payout_ref" => $referenceNumber,
//                     "txn_id" => $merchantId,
//                     "bank_ref" => $clientutr,
//                 ),
//             ];
//             DB::commit();
//             return response()->json($responseData, 200);
//         }

//         if($status == "Success") {
         

//             $updateUser = [
//                 'status' => "SUCCESS"
//             ];  

//             $UserTransaction = new UserTransaction();      
//             $UserTransaction->updateUserTxnData($updateUser,$merchantId);

//             $updatePayout = [
                
//                 "utr"=> $clientutr,
//                 "payoutId"=> $clientgatewayid,    
//                 "status"=>"SUCCESS",
                
//               // "remark"=>$statusMessage
//             ];                  
//             $PayoutModel = new PayoutModel();      
//             $PayoutModel->updatePayoutData($updatePayout,$merchantId);

        
//         $responseData = [
//                 "status" => "SUCCESS",
//                 "message" => "Transaction is Successful",
//                 "data" => array(
//                   "payout_ref" => $referenceNumber,
//                     "txn_id" => $merchantId,
//                     "bank_ref" => $clientutr
//                 ),
//             ];
//             DB::commit();
//             return response()->json($responseData, 200);
//         }
        
//           if($status == "Pending" || $status == "Initiated") {
              
//               $updatePayout = [
//                 "payoutId"=> $clientgatewayid,    

//             ];                  
//             $PayoutModel = new PayoutModel();      
//             $PayoutModel->updatePayoutData($updatePayout,$merchantId);
     
//          $responseData = [
//                 "status" => "Pending",
//                  "message" => "Transaction is Pending",
//                 "data" => array(
//                   "payout_ref" => $referenceNumber,
//                     "txn_id" => $merchantId,
//                     "bank_ref" => ""
//                 ),
//             ];
//             DB::commit();
//             return response()->json($responseData, 200);
//           }
          
// }}
    

        }
}
   
}
