<?php

namespace App\Http\Controllers\API\ISERVEU;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Carbon;
use App\Models\User;
use App\Models\UserCharge;
use App\Models\UserIp;
use App\Models\UserTransaction;
use App\Models\PayoutModel;
use App\Models\ApiLog;

class PayoutController extends Controller
{
    public function doPayout(Request $request)
    {
        $jsonData = $request->json()->all();        
        $AuthKey = $request->header('AuthKey');  
        $AuthToken = $request->header('AuthToken');
        $AuthCode = $request->header('AuthCode');

        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'accountNumber' => 'required',
            'bankIfsc' => 'required',
            'mobileNumber' => 'required',
            'beneBankName' => 'required',
            'referenceNumber' => 'required|unique:payout_transactions,orderId',
            'transferAmount' => 'required',
            'transferMode' => 'required',
        ]);

        if($validator->fails()) {
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => $validator->errors(),
            ];
            return response()->json($responseData, 422);
        }

        $getUser = User::where("user_token",$AuthToken)->where("user_key",$AuthKey)->where("status",1)->where("api_status",1)->where("user_type",1)->where("approved",1)->first();
        if(empty($getUser)){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'Invalid credentials',
            ];
            return response()->json($responseData , 401);
        }
        if (Hash::check($AuthCode, $getUser->authCode)) {

        }else{
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'Invalid credentials!',
            ];
            return response()->json($responseData , 401);
            die;
        }
        $userId = $getUser->id;
        $api_status = $getUser->api_status;
        if($api_status == 0){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'We are taking downtime due to some technical issues. Please wait till further update',
            ];
            return response()->json($responseData , 200);die;
        }
        $bank_deactive = $getUser->bank_deactive;
        if($bank_deactive == 1){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'Your API has been Deactivated by the Bank due to security reasons.',
            ];
            return response()->json($responseData , 200);die;
        }
        $tecnical_issue = $getUser->tecnical_issue;
        if($tecnical_issue == 1){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'We are facing technical issue from bank side.',
            ];
            return response()->json($responseData , 200);die;
        }

        $iserveu = $getUser->iserveu;
        if($iserveu != 1){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'This service is not active at this time. please use ICICI bank api.',
            ];
            return response()->json($responseData , 200);die;
        }

        $ipAddress = $request->ip();
        $checkIp = UserIp::where(['userId'=>$userId,'ipAddress'=>$ipAddress])->first();
        if(empty($checkIp)){
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'your ip is not whitlisted, requested ip is '.$ipAddress,
            ];
            return response()->json($responseData , 401);
        }

        $txn_id = "SSPY".rand(123121,990999).Carbon::now()->timestamp;
        $name = $request['name'];
        $accountNumber = $request['accountNumber'];
        $bankIfsc = $request['bankIfsc'];
        $mobileNumber = $request['mobileNumber'];
        $beneBankName = $request['beneBankName'];
        $referenceNumber = $request['referenceNumber'];
        $transferAmount = $request['transferAmount'];
        $transferMode = $request['transferMode'];

        if($userId != 29)
        {
            if($bankIfsc == "AIRP0000001" || $bankIfsc == "PYTM0123456")
            {
                $responseData = [                
                    'status' => FALSE,
                    'error'=> TRUE,
                    'message' => 'Transaction not allowed in this bank',
                ];
                return response()->json($responseData , 401);
                die;
            }
        }
        
        $getCommission = UserCharge::where('start_amount', '<=', $transferAmount)->where('end_amount', '>=', $transferAmount)->where('userId', '=', $userId)->first();
        if(empty($getCommission)){
            $charge = 20;
            $chargeType = "F";
        }else{
            $charge = $getCommission->payout_charge;
            $chargeType = $getCommission->payout_charge_type;
        }
        $gst = 18;
        if($chargeType == "F"){
            $totalCharge = $charge;
            $totalGst = ($totalCharge*$gst)/100;
        }else if($chargeType == "P"){
            $totalCharge = ($transferAmount*$charge)/100;
            $totalGst = ($totalCharge*$gst)/100;
        }
        $totalDeductAmount = $transferAmount +$totalCharge+$totalGst;
        $openBal = $getUser->wallet;
        $lien =$getUser->lien;
        $rolling_reserve = $getUser->rolling_reserve;
        $closeBal = $openBal - $totalDeductAmount;                    
        $checkAmount = $totalDeductAmount+$lien+$rolling_reserve;

        if($openBal == 0 || $openBal < $checkAmount){           
            $responseData = [                
                'status' => FALSE,
                'error'=> TRUE,
                'message' => 'Insufficient fund',
            ];
            return response()->json($responseData , 200);
        }
        
        $UserInstance = new User();
        $UserInstance->deductFund($userId,$totalDeductAmount);

        $remark = "Money Transfer Via Payout ";
        UserTransaction::create([
            'userId' => $userId,
            'txnId' => $txn_id,
            'orderId' => $referenceNumber,
            'type' => "DEBIT",  
            'operator' => "PAYOUT",
            'openBalance' =>$openBal, 
            'amount' => $totalDeductAmount,
            'walletBalance' =>$closeBal,
            'credit' =>0, 
            'debit' =>$totalDeductAmount,
            "status" => "PENDING",
            'remark' => $remark,   
            'api'=>"ISERVEU",
            'requestIp' => $ipAddress,          
            'created_by' => $userId,
        ]);

        PayoutModel::create([
            'userId' => $userId,
            'txnId' => $txn_id,
            'orderId' => $referenceNumber,
            'amount' => $transferAmount,
            'charge' =>$totalCharge,   
            'gst'=>$totalGst,
            'totalAmount' => $totalDeductAmount,   
            'mode'=>$transferMode,
            'beneName' => $name,          
            'beneBank' => $beneBankName,
            'beneAccount' => $accountNumber,   
            'beneIfsc' => $bankIfsc,          
            'status' => "PENDING",
            'api'=>"ISERVEU",
            'IpAddress' => $ipAddress,
        ]);

        $pincode = "201310";
        $customerName = $getUser->name;
        $customerMobileNumber = $getUser->mobile;
        $latitude = 19.0748;
        $longitude = 72.8856;        

        $ISERVEU_CLIENT_ID = "c88f9e5d9f49709cd8a623266e701ca7bdf81c2f53d564bafe11cc9badfe289564e3824a98ad5edda15e065e721820e7";
        $ISERVEU_CLIENT_SECRET = "08dbf0b2a09d489df40e246d6d2cf8a914133f2dffe781878610e207665cb5ac0afb338dfa115129ca27d741d183e8168805f0f6fdfba2ede769f280615c9d65";
        
        
        // $numberString = (string)$transferAmount;
        // $lastTwoCharacters = substr($numberString, -2);
        // if($lastTwoCharacters === "00") {
        //     $responseData = [
        //         "status" => "PENDING",
        //         "message" => "Transaction is under process",
        //         "data" => array(
        //             "payout_ref" => $referenceNumber,
        //             "txn_id" => $txn_id,
        //             "bank_ref" => ""
        //         ),
        //     ];
        //     return response()->json($responseData , 200);
        //     die;
        // }

        // if($transferAmount > 19999)
        // {
        //     $responseData = [
        //         "status" => "PENDING",
        //         "message" => "Transaction is under process",
        //         "data" => array(
        //             "payout_ref" => $referenceNumber,
        //             "txn_id" => $txn_id,
        //             "bank_ref" => ""
        //         ),
        //     ];
        //     return response()->json($responseData , 200);
        //     die;
        // }
        
        // $ISERVEU_CLIENT_ID = "19f0b82156edf5096bb7a4f5c67f70d52c8b0c0b2b642f102a951e541a227768cec17f97f0ca7df7e7f9089e670c2f97";
        // $ISERVEU_CLIENT_SECRET = "6ef770dc482357db0635c61ea4dcfc10dad99834a1d7581a1ff8cc7dbfd467444f94508bb758d9d1213bb569bf73383b4caa2d1fa309443a959b909107d2c161";

        $header = array(
            'Content-Type:application/json',
            'client_id: ' . $ISERVEU_CLIENT_ID,
            'client_secret: ' . $ISERVEU_CLIENT_SECRET
        );

        $request = [
            "beneName" => $name,
            "beneAccountNo" => $accountNumber,
            "beneifsc" => $bankIfsc,
            "benePhoneNo" => (int)$mobileNumber,
            "beneBankName" => $beneBankName,
            "clientReferenceNo" => $txn_id,
            "amount" => (float)$transferAmount,
            "fundTransferType" => $transferMode,
            "pincode" => (int)$pincode,
            "custName" => $customerName,
            "custMobNo" => $customerMobileNumber,
            "custIpAddress" => $ipAddress,
            "latlong" => $latitude . ',' . $longitude
        ];

        $payload = json_encode($request);

        $curl = curl_init();

        curl_setopt_array($curl, [
            CURLOPT_URL => "https://apigatewayprod.iserveu.tech/w1w2-payout/w1/cashtransfer",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $payload,
            CURLOPT_HTTPHEADER => $header
        ]);

        $response = curl_exec($curl);
        //$response = '{"transactionId":275424305152050,"subStatus":0,"status":"SUCCESS","statusDesc":"CO00 - Transaction is Successful.","beneName":"AJAY SHARMA SO BAL KRISHAN  SHARMA","beneAccountNo":"0240040150000474","beneifsc":"JAKA0CHNDAR","benePhoneNo":"9008770493","beneBankName":"JAKA","clientReferenceNo":"301253949604","latlong":"19.0748,72.8856","pincode":"141001","custName":"G K","custMobNo":"9988894793","rrn":"324016072167","paramA":"","paramB":"","dateTime":"08-28-2023 04:24:36","txnAmount":475,"txnType":"IMPS"}';
        $err = curl_error($curl);
        curl_close($curl);

        ApiLog::create([
            'txnId' => $txn_id,
            'request' => $payload,
            'response' => $response,  
            'service' => "PAYOUT",
            'service_api' =>"ISERVEU",   
        ]);

        $responseData = json_decode($response, true);                    
        $status = $responseData['status'];
        $statuscode = $responseData['subStatus'];
        $statusMessage = $responseData['statusDesc'];
        $transactionId = $responseData['transactionId'];        
        $clientReferenceNo = $responseData['clientReferenceNo'];

        

        if($statuscode == "-1" ||$statuscode == "2" ||$statuscode == "-2" || $status == "FAILED"){

            $updateUser = [
                'walletBalance' =>$openBal,
                'status' => "FAILED"
            ];  

            $UserTransaction = new UserTransaction();      
            $UserTransaction->updateUserTxnData($updateUser,$txn_id);

            $updatePayout = [
                "contactId"=>$transactionId,                
                "status"=>"FAILED",
                "remark"=>$statusMessage
            ];                  
            $PayoutModel = new PayoutModel();      
            $PayoutModel->updatePayoutData($updatePayout,$txn_id);

            //$user = User::findOrFail($userId);
            $UserInstance = new User();
            $UserInstance->addFund($userId,$totalDeductAmount);

            $responseData = [
                "status" => "FAILED",
                "message" => $statusMessage,
                "data" => array(
                    "payout_ref" => $referenceNumber,
                    "txn_id" => $txn_id,
                    "bank_ref" => ""
                ),
            ];
            return response()->json($responseData , 200);
            die;
        }

        if($statuscode == "0" && $status == "SUCCESS") {
            $rrn = $responseData['rrn'];

            $updateUser = [
                'status' => "SUCCESS"
            ];  

            $UserTransaction = new UserTransaction();      
            $UserTransaction->updateUserTxnData($updateUser,$txn_id);

            $updatePayout = [
                "contactId"=>$transactionId,
                "utr"=>$rrn,
                "status"=>"SUCCESS",
                "remark"=>$statusMessage
            ];                  
            $PayoutModel = new PayoutModel();      
            $PayoutModel->updatePayoutData($updatePayout,$txn_id);

            $responseData = [
                "status" => "SUCCESS",
                "message" => $statusMessage,
                "data" => array(
                    "payout_ref" => $referenceNumber,
                    "txn_id" => $txn_id,
                    "bank_ref" => $rrn
                ),
            ];
            return response()->json($responseData , 200);
            die;
        }

        $responseData = [
            "status" => "PENDING",
            "message" => "Transaction is under process",
            "data" => array(
                "payout_ref" => $referenceNumber,
                "txn_id" => $txn_id,
                "bank_ref" => ""
            ),
        ];
        return response()->json($responseData , 200);
        die;
    }
}
